unit httpmain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Buttons, agsocket, aghttp;

type
  THTTPForm = class(TForm)
    Panel1: TPanel;
    URLEdit: TEdit;
    Label1: TLabel;
    GetButton: TBitBtn;
    CancelButton: TBitBtn;
    StatusBar1: TPanel;
    SaveDialog1: TSaveDialog;
    Memo1: TMemo;
    HTTP1: TagHTTP;
    procedure GetButtonClick(Sender: TObject);
    procedure HTTP1Cancel(Sender: TObject);
    procedure HTTP1Closed(Sender: TObject);
    procedure HTTP1Open(Sender: TObject);
    procedure HTTP1Sending(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure HTTP1Error(Sender: TObject; var Msg: OpenString);
    procedure HTTP1RecvProgress(Sender: TObject; Progress: Longint);
  private
    { Private declarations }
    procedure EnableControls;
    procedure DisableControls;
    procedure SaveData;
  public
    { Public declarations }
  end;

var
  HTTPForm: THTTPForm;

implementation

{$R *.DFM}

procedure THTTPForm.DisableControls;
begin
  URLEdit.Enabled:=false;
  GetButton.Enabled:=false;
  CancelButton.Enabled:=true;
end;

procedure THTTPForm.EnableControls;
begin
  URLEdit.Enabled:=true;
  GetButton.Enabled:=true;
  CancelButton.Enabled:=false;
end;

procedure THTTPForm.SaveData;
var
  Ext : string;
begin
  Ext:=ExtractFileExt(HTTP1.FileName);
  if Length(Ext)>4 then
  begin
    Ext:=Copy(Ext,1,4);
    SaveDialog1.FileName:=ChangeFileExt(HTTP1.FileName,Ext);
  end
  else
    SaveDialog1.FileName:=HTTP1.FileName;
  if SaveDialog1.Execute then
    HTTP1.OutStream.SaveToFile(SaveDialog1.FileName);
end;

procedure THTTPForm.GetButtonClick(Sender: TObject);
begin
  HTTP1.LogFileName:='c:\temp\blah.log';
  DisableControls;
  try
    HTTP1.URL:=URLEdit.Text;
    HTTP1.Get;
    Memo1.Lines:=HTTP1.Headers;
    if MessageDlg('Do you want to save retrieved data?',
                   mtConfirmation,[mbYes,mbNo],0)=mrYes then
      SaveData;
  finally
    EnableControls;
  end;
end;

procedure THTTPForm.HTTP1Cancel(Sender: TObject);
begin
  StatusBar1.Caption:='Operation canceled';
end;

procedure THTTPForm.HTTP1Closed(Sender: TObject);
begin
  StatusBar1.Caption:='Connection closed';
end;

procedure THTTPForm.HTTP1Open(Sender: TObject);
begin
  StatusBar1.Caption:='Opening connection';
end;

procedure THTTPForm.HTTP1Sending(Sender: TObject);
begin
  StatusBar1.Caption:='Sending Query';
end;

procedure THTTPForm.CancelButtonClick(Sender: TObject);
begin
  HTTP1.Cancel;
end;

procedure THTTPForm.HTTP1Error(Sender: TObject; var Msg: OpenString);
begin
  StatusBar1.Caption:=Msg;
end;

procedure THTTPForm.HTTP1RecvProgress(Sender: TObject; Progress: Longint);
begin
  StatusBar1.Caption:=IntToStr(Progress)+' bytes received';
end;

end.
